DontDisableSteerAssistWhileChangeDirection = {}

function DontDisableSteerAssistWhileChangeDirection:AIAutomaticSteeringOnUpdateTick(superFunc, dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    local spec = self.spec_aiAutomaticSteering

    if isActiveForInputIgnoreSelection then
        if self:getAIModeSelection() == AIModeSelection.MODE.STEERING_ASSIST then
            local x, _, z = localToWorld(self.rootNode, 0, 0, self.size.length * 0.5 + self.size.lengthOffset)
            x, z = g_fieldCourseManager:roundToTerrainDetailPixel(x, z)

            local isOnField = getDensityAtWorldPos(g_currentMission.terrainDetailId, x, 0, z) ~= 0
            if not isOnField then
                x, _, z = localToWorld(self.rootNode, 0, 0, -self.size.length * 0.5 + self.size.lengthOffset + 1) -- add one meter offset to not get into the work area of the tool
                x, z = g_fieldCourseManager:roundToTerrainDetailPixel(x, z)

                isOnField = getDensityAtWorldPos(g_currentMission.terrainDetailId, x, 0, z) ~= 0
            end

            local farmId = self:getActiveFarm()
            local hasAccess = g_currentMission.accessHandler:canFarmAccessLand(farmId, x, z) or g_missionManager:getIsMissionWorkAllowed(farmId, x, z, nil, self)
            if not hasAccess then
                isOnField = false
            end

            if isOnField ~= spec.lastIsOnField or spec.forceFieldCourseUpdate then
                spec.lastIsOnField = isOnField

                if isOnField then
                    spec.resetCourseTimer = 0
                    local workingWidth = self:getAttacherToolWorkingWidth()

                    local generateCourse = true
                    if spec.steeringFieldCourse ~= nil and not spec.forceFieldCourseUpdate then
                        if spec.steeringFieldCourse:getIsPointInsideBoundary(x, z) then
                            -- working width can be 0 for tools without work areas (e.g. vine harvesters)
                            if workingWidth == 0 or math.abs(workingWidth - spec.steeringFieldCourse.fieldCourseSettings.implementWidth) < 0.05 then
                                generateCourse = false
                            end
                        end
                    end

                    if generateCourse then
                        self:initializeLoadedAIModeUserSettings()
                        local fieldCourseSettings = self:getAIModeFieldCourseSettings()
                        if fieldCourseSettings == nil then
                            fieldCourseSettings, _ = FieldCourseSettings.generate(self.rootVehicle)
                        end

                        if VehicleDebug.state == VehicleDebug.DEBUG_AI then
                            fieldCourseSettings:print()
                        end

                        g_client:getServerConnection():sendEvent(AIAutomaticSteeringRequestEvent.new(self, x, z, fieldCourseSettings))
                    end
                else
                    spec.resetCourseTimer = AIAutomaticSteering.RESET_COURSE_TIME
                end

                spec.forceFieldCourseUpdate = false
            end

            if not isOnField and not spec.steeringEnabled then
                if spec.resetCourseTimer > 0 then
                    spec.resetCourseTimer = spec.resetCourseTimer - dt
                    if spec.resetCourseTimer <= 0 then
                        self:setAIAutomaticSteeringCourse(nil)
                    end
                end
            end
        end
    end
end

AIAutomaticSteering.onUpdateTick = Utils.overwrittenFunction(AIAutomaticSteering.onUpdateTick, DontDisableSteerAssistWhileChangeDirection.AIAutomaticSteeringOnUpdateTick)
