-- prefer mod lamps; Utils.prependedFunction will break HandToolTethered
Player.onPickupHandTool = Utils.overwrittenFunction(Player.onPickupHandTool, function(self, superFunc, handTool, ...)
    if handTool ~= nil and not handTool.canBeSaved and handTool.configFileName == "data/handTools/brandless/flashlight/flashlight.xml" then
        table.insert(self.carriedHandTools, 2, handTool)
    end
    return superFunc(self, handTool, ...)
end)

Player.setCurrentHandTool = Utils.overwrittenFunction(Player.setCurrentHandTool, function(self, superFunc, handTool, noEventSend)
    if handTool == nil then
        handTool = self.hands
    end

    local lastHandTool = self.currentHandTool
    self.lastHandToolIndex = table.find(self.carriedHandTools, lastHandTool)
    if lastHandTool ~= nil then
        lastHandTool:stopHolding()
    end

    if not self:getIsCarryingHandTool(handTool) then return false end

    local handToolId = NetworkUtil.getObjectId(handTool)
    if handToolId == nil then return false end

    handTool:startHolding()

    self.currentHandTool = handTool
    self.currentHandToolIndex = table.find(self.carriedHandTools, handTool)

    PlayerHoldHandToolEvent.sendEvent(self, handToolId, noEventSend)

    return true
end)

Player.setFlashlightIsActive = Utils.overwrittenFunction(Player.setFlashlightIsActive, function(self, superFunc, isActive, noEventSend)
    local currentHandTool = self.currentHandTool or self.hands
    if currentHandTool == nil then return end
    local flashlight = self.carriedHandTools[self.lastFlashlightIndex]
    if flashlight ~= nil and not flashlight.isFlashlight then
        flashlight = nil
    end

    if currentHandTool.isFlashlight and flashlight ~= nil and currentHandTool ~= flashlight and flashlight.spec_flashlight.isActive then
        flashlight:setFlashlightIsActive(false, noEventSend)
        isActive = true
    end

    if currentHandTool.isFlashlight then
        flashlight = currentHandTool
    elseif flashlight == nil then
        for _, handTool in ipairs_reverse(self.carriedHandTools) do
            if handTool.isFlashlight then
                flashlight = handTool
                break
            end
        end
    end
    if flashlight == nil then return end

    self.lastFlashlightIndex = table.find(self.carriedHandTools, flashlight)
    self.isFlashlightActive = isActive
    flashlight:setFlashlightIsActive(isActive, noEventSend)
end)

HandToolFlashlight.onHeldEnd = Utils.overwrittenFunction(HandToolFlashlight.onHeldEnd, function(self, superFunc)
    -- don't turn off
end)